package ru.yandex.webmaster3.storage.turbo.service.preview;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.ToString;
import lombok.Value;
import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.webmaster3.core.turbo.model.menu.TurboMenuItem;

/**
 * WMC-8085 - адаптер для Турбо
 * Created by Oleg Bazdyrev on 13/12/2019.
 */
@Value
@ToString
public class TurboMenuItemData {

    @JsonProperty("id")
    private final Long id;
    @JsonProperty("label")
    private final String label;
    @JsonProperty("url")
    private final String url;
    @JsonProperty("order")
    private final Long order;
    @JsonProperty("parent_id")
    private final Long parentId;

    public static List<TurboMenuItemData> fromMenu(List<TurboMenuItem> topMenu, boolean withChildren) {
        List<TurboMenuItemData> result = new ArrayList<>();
        processItems(result, topMenu, withChildren ? new AtomicLong() : null, null, withChildren);
        return result;
    }

    private static void processItems(List<TurboMenuItemData> result, List<TurboMenuItem> menuItems,
                                     AtomicLong idCounter, Long parentId, boolean processChildren) {
        if (CollectionUtils.isEmpty(menuItems)) {
            return;
        }
        for (int i = 0; i < menuItems.size(); i++) {
            TurboMenuItem menuItem = menuItems.get(i);
            if (processChildren) {
                long id = menuItem.getId() == null ? idCounter.incrementAndGet() : menuItem.getId();
                result.add(new TurboMenuItemData(id, menuItem.getLabel(), menuItem.getUrl(), (long) i, parentId));
                processItems(result, menuItem.getSubmenu(), idCounter, id, processChildren);
            } else {
                result.add(new TurboMenuItemData(null, menuItem.getLabel(), menuItem.getUrl(), null, null));
            }
        }
    }

}
