package ru.yandex.webmaster3.storage.turbo.service.preview;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.turbo.model.search.TurboSearchSettings;

/**
 * Created by Oleg Bazdyrev on 01/04/2019.
 */
public class TurboSearchSettingsData {
    private final String url;
    private final String charset;
    private final String placeholder;

    @JsonCreator
    public TurboSearchSettingsData(@JsonProperty("url") String url,
                                   @JsonProperty("charset") String charset,
                                   @JsonProperty("placeholder") String placeholder) {
        this.url = url;
        this.charset = charset;
        this.placeholder = placeholder;
    }

    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @JsonProperty("charset")
    public String getCharset() {
        return charset;
    }

    @JsonProperty("placeholder")
    public String getPlaceholder() {
        return placeholder;
    }

    public static TurboSearchSettingsData fromSearchSettings(TurboSearchSettings settings) {
        if (settings == null) {
            return null;
        }

        return new TurboSearchSettingsData(settings.getUrl(), settings.getCharset(), settings.getPlaceholder());
    }
}
