package ru.yandex.webmaster3.storage.turbo.service.preview.app;

import java.util.Base64;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

/**
 * Created by Oleg Bazdyrev on 21/07/2020.
 */
@Value
public class TurboAppReviewsInfo {
    // TODO в сервис?
    private static final String UGC_LINK_PATTERN = "https://yandex.ru/ugcpub/object-digest?object=/site/%s&otype=Site&app_id=object-digest&" +
            "ranking=by_relevance&disable_termometr_rating_count=0";


    @JsonProperty("rating")
    Double rating;
    @JsonProperty("count")
    Long count;
    @JsonProperty("link")
    String link;


    public static TurboAppReviewsInfo empty(String domain) {
        return new TurboAppReviewsInfo(0.0, 0L, null);
    }

    public static String defaultLink(String domain) {
        return String.format(UGC_LINK_PATTERN, Base64.getEncoder().encodeToString(domain.getBytes()));
    }

    public TurboAppReviewsInfo setDefaults(String domain) {
        return new TurboAppReviewsInfo(rating == null ? 0.0D : rating,
                count == null ? 0L : count,
                link
        );
    }

}
