package ru.yandex.webmaster3.storage.turbo.service.preview.commerce;

import java.util.Optional;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.RequiredArgsConstructor;

import ru.yandex.webmaster3.core.turbo.model.TurboHostHeader;

@RequiredArgsConstructor
public class HeaderParamsInfo {
    private final boolean headerFixed;

    @JsonProperty("header_fixed")
    public boolean getHeaderFixed() {
        return headerFixed;
    }

    public static HeaderParamsInfo fromHeaderSettings(TurboHostHeader headerSettings) {
        return Optional.ofNullable(headerSettings)
                .map(TurboHostHeader::getHeaderParams)
                .map(x -> new HeaderParamsInfo(x.isFrozen()))
                .orElse(null);
    }
}
