package ru.yandex.webmaster3.storage.turbo.service.preview.commerce;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboCommerceSettings;

/**
 * @author kravchenko99
 * @date 12/23/20
 */

@Value
public class MarketInfo {

    @JsonProperty("info_sections")
    List<ProductInfoSection> infoSections;


    public static MarketInfo fromTurboSettings(TurboHostSettings settings) {
        final TurboCommerceSettings commerce = settings.getCommerceSettings();
        if (commerce == null) {
            return null;
        }

        List<ProductInfoSection> infoSections = Collections.emptyList();
        if (commerce.getInfoSections() != null) {
            infoSections = commerce.getInfoSections().stream().map(ProductInfoSection::fromCommerceInfoSection)
                    .collect(Collectors.toList());
        }
        return new MarketInfo(infoSections);
    }
}
