package ru.yandex.webmaster3.storage.turbo.service.preview.commerce;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import lombok.With;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.webmaster3.core.payments.ServiceMerchantInfo;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboPaymentsSettings;

/**
 * Created by Oleg Bazdyrev on 2019-05-30.
 */
@Value
@With
public class PaymentInfo {

    @JsonProperty("service_merchant_id")
    String serviceMerchantId;
    @JsonProperty("default_vat")
    String defaultVat;
    @JsonProperty("enabled_methods")
    List<PaymentMethodInfo> enabledMethods;


    public static Pair<Boolean, PaymentInfo> fromPaymentsSettings(TurboPaymentsSettings paymentSettings) {
        boolean paymentEnabled = false;
        PaymentInfo paymentInfo = null;
        if (paymentSettings != null) {
            ServiceMerchantInfo merchantInfo = paymentSettings.getMerchantInfo();
            String merchantInfoId = null;
            String defaultVat = null;
            if (merchantInfo != null && merchantInfo.isActive()) {
                paymentEnabled = paymentSettings.isEnabled();
                merchantInfoId = String.valueOf(merchantInfo.getId());
                defaultVat = Objects.toString(paymentSettings.getDefaultVat(), null);

            }
            paymentInfo = new PaymentInfo(merchantInfoId, defaultVat, PaymentMethodInfo.fromPaymentMethodsSettings(paymentSettings.getPaymentMethods()));

        }
        return Pair.of(paymentEnabled, paymentInfo);
    }
}
