package ru.yandex.webmaster3.storage.turbo.service.preview.commerce;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import org.apache.commons.collections.CollectionUtils;

import ru.yandex.webmaster3.core.turbo.model.commerce.PaymentMethodSettings;

/**
 * @author kravchenko99
 * @date 12/10/20
 */
@Value
public class PaymentMethodInfo {
    @JsonProperty("value")
    String value;
    @JsonProperty("description")
    String description;
    @JsonProperty("label")
    String label;

    private static PaymentMethodInfo fromPaymentMethodSettings(PaymentMethodSettings methodSettings) {
        return new PaymentMethodInfo(methodSettings.getName().getValue(), methodSettings.getDescription(), methodSettings.getLabel());
    }

    static List<PaymentMethodInfo> fromPaymentMethodsSettings(Set<PaymentMethodSettings> paymentMethods) {
        if (CollectionUtils.isEmpty(paymentMethods)) {
            return Collections.emptyList();
        }

        return paymentMethods.stream()
                .filter(PaymentMethodSettings::isEnabled)
                .map(PaymentMethodInfo::fromPaymentMethodSettings)
                .collect(Collectors.toList());
    }
}
