package ru.yandex.webmaster3.storage.turbo.service.preview.commerce;

import ru.yandex.webmaster3.core.turbo.model.commerce.TurboCommerceInfoSection;
import ru.yandex.webmaster3.storage.turbo.service.preview.TurboHostSettingsData;

/**
 * Created by Oleg Bazdyrev on 19/11/2018.
 */
public final class ProductInfoSection {

    private final String title;
    private final String value;

    public ProductInfoSection(String title, String value) {
        this.title = title;
        this.value = value;
    }

    public String getTitle() {
        return title;
    }

    public String getValue() {
        return value;
    }

    public static ProductInfoSection fromCommerceInfoSection(TurboCommerceInfoSection section) {
        return new ProductInfoSection(section.getTitle(), section.getValue());
    }
}
