package ru.yandex.webmaster3.storage.turbo.service.preview.commerce;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;
import ru.yandex.webmaster3.core.payments.ServiceMerchantOrganization;
import ru.yandex.webmaster3.core.turbo.model.commerce.TurboPaymentsSettings;

/**
 * Created by Oleg Bazdyrev on 2019-10-25.
 */
@Value
public class ShopInfo {

    @JsonProperty("name")
    String name;
    @JsonProperty("full_name")
    String fullName;
    @JsonProperty("english_name")
    String englishName;
    @JsonProperty("type")
    String type;
    @JsonProperty("inn")
    String inn;
    @JsonProperty("ogrn")
    String ogrn;
    @JsonProperty("kpp")
    String kpp;
    @JsonProperty("site_url")
    String siteUrl;
    @JsonProperty("description")
    String description;
    @JsonProperty("schedule_text")
    String scheduleText;

    public static ShopInfo fromPaymentsSettings(TurboPaymentsSettings paymentsSettings) {
        if (paymentsSettings == null || paymentsSettings.getMerchantInfo() == null
                || paymentsSettings.getMerchantInfo().getOrganization() == null) {
            return null;
        }
        ServiceMerchantOrganization smo = paymentsSettings.getMerchantInfo().getOrganization();
        return new ShopInfo(
                smo.getName(),
                smo.getFullName(),
                smo.getEnglishName(),
                smo.getType(),
                smo.getInn(),
                smo.getOgrn(),
                smo.getKpp(),
                smo.getSiteUrl(),
                smo.getDescription(),
                smo.getScheduleText()
        );
    }
}
