package ru.yandex.webmaster3.storage.turbo.service.preview.commerce;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Value;

import ru.yandex.webmaster3.core.turbo.model.commerce.TurboPlusSettings;

/**
 * Created by Oleg Bazdyrev on 25/02/2019.
 */
@Value
public class TurboPlusSettingsData {

    @JsonProperty("safe_shopping")
    boolean safeShopping;

    public static TurboPlusSettingsData fromPlusSettings(TurboPlusSettings plusSettings) {
        if (plusSettings == null) {
            return null;
        }
        return new TurboPlusSettingsData(plusSettings.isSafeShopping());
    }
}
