package ru.yandex.webmaster3.storage.turbo.service.validation;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.HttpCodeInfo;

/**
 * Created by Oleg Bazdyrev on 07/11/2018.
 */
public class CartUrlValidationResult {

    private final String resultingCartUrl;
    private final HttpCodeInfo httpCodeInfo;
    private final boolean containsOfferName;
    private final boolean containsOfferUrl;
    private final boolean hasJavascriptRedirect;
    private final boolean containsOfferPath;
    private final boolean cartPageValid;

    public CartUrlValidationResult() {
        this(null, null, true, true, true, true);
    }

    public CartUrlValidationResult(String resultingCartUrl, HttpCodeInfo httpCodeInfo, boolean containsOfferName,
                                   boolean containsOfferUrl, boolean hasJavascriptRedirect, boolean containsOfferPath) {
        this.resultingCartUrl = resultingCartUrl;
        this.httpCodeInfo = httpCodeInfo;
        this.containsOfferName = containsOfferName;
        this.containsOfferUrl = containsOfferUrl;
        this.hasJavascriptRedirect = hasJavascriptRedirect;
        this.containsOfferPath = containsOfferPath;
        this.cartPageValid = containsOfferName || containsOfferUrl || hasJavascriptRedirect || containsOfferPath;
    }

    @Description("Какую страницу корзины в итоге проверяли")
    public String getResultingCartUrl() {
        return resultingCartUrl;
    }

    @Description("HTTP код, с которым скачалась страница")
    public HttpCodeInfo getHttpCodeInfo() {
        return httpCodeInfo;
    }

    @Description("На странице есть название товара")
    public boolean isContainsOfferName() {
        return containsOfferName;
    }

    @Description("На странице есть ссылка на товар")
    public boolean isContainsOfferUrl() {
        return containsOfferUrl;
    }

    @Description("На странице есть js-редирект (location.href = ...)")
    public boolean isHasJavascriptRedirect() {
        return hasJavascriptRedirect;
    }

    @Description("На странице есть ссылка на товар без параметров (без query)")
    public boolean isContainsOfferPath() {
        return containsOfferPath;
    }

    @Description("Итоговое значение - валидна ли страница корзины")
    public boolean isCartPageValid() {
        return cartPageValid;
    }

    @Override
    public String toString() {
        return "CartUrlValidationResult{" +
                "resultingCartUrl='" + resultingCartUrl + '\'' +
                ", httpCodeInfo=" + httpCodeInfo +
                ", containsOfferName=" + containsOfferName +
                ", containsOfferUrl=" + containsOfferUrl +
                ", hasJavascriptRedirect=" + hasJavascriptRedirect +
                ", containsOfferPath=" + containsOfferPath +
                ", cartPageValid=" + cartPageValid +
                '}';
    }
}
