package ru.yandex.webmaster3.storage.turbo.service.validation;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;

import ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement;

import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.ASIDE_LEFT;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.ASIDE_RIGHT;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.CONTENT;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.HORIZONTAL;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.MANUAL_STICKY;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.MANUAL_TAPE;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.MANUAL_TOP;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.STICKY;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.TAPE;
import static ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingPlacement.TOP;

/**
 * Created by Oleg Bazdyrev on 04/03/2019.
 */
public interface PartnerBlockConstants {

    String SITE_VERSION_TURBO = "turbo";
    String SITE_VERSION_TURBO_DESKTOP = "turbo_desktop";
    String SITE_VERSION_DESKTOP = "desktop";

    // desktop
    Map<AdvertisingPlacement, Set<String>> POSSIBLE_FORMATS_BY_PLACEMENT =
            new EnumMap<>(ImmutableMap.<AdvertisingPlacement, Set<String>>builder()
                    .put(TOP, Sets.newHashSet("modernAdaptive", "adaptive0418", "extensibleMobile", "motion"))
                    .put(HORIZONTAL, Sets.newHashSet("modernAdaptive", "adaptive0418", "extensibleMobile", "motion"))
                    .put(ASIDE_LEFT, Sets.newHashSet("posterVertical", "modernAdaptive", "adaptive0418", "240x400"))
                    .put(ASIDE_RIGHT, Sets.newHashSet("posterVertical", "modernAdaptive", "adaptive0418", "300x600", "300x500", "240x400"))
                    .put(CONTENT, Sets.newHashSet("posterHorizontal", "horizontal", "modernAdaptive", "adaptive0418"))
                    .build());

    Map<AdvertisingPlacement, Set<String>> POSSIBLE_MEDIA_SIZES_BY_PLACEMENT =
            new EnumMap<>(ImmutableMap.<AdvertisingPlacement, Set<String>>builder()
                    .put(TOP, Sets.newHashSet("100%x90", "100%x120", "100%x180", "100%x200", "100%x250", "728x90", "970x90", "970x250", "1000x120"))
                    .put(HORIZONTAL, Sets.newHashSet("100%x90", "100%x120", "100%x180", "100%x200", "100%x250", "728x90", "970x90", "970x250", "1000x120"))
                    .put(ASIDE_LEFT, Sets.newHashSet("160x600", "240x400", "240x600"))
                    .put(ASIDE_RIGHT, Sets.newHashSet("160x600", "240x400", "240x600", "300x300", "300x500", "300x600"))
                    .put(CONTENT, Sets.newHashSet("728x90", "100%x90", "100%x120", "100%x180", "100%x200", "100%x250"))
                    .build());

    // mobile
    Map<AdvertisingPlacement, Set<String>> POSSIBLE_FORMATS_BY_PLACEMENT_MOBILE =
            new EnumMap<>(ImmutableMap.<AdvertisingPlacement, Set<String>>builder()
                    .put(TOP, Sets.newHashSet("adaptive", "modernAdaptive", "adaptive0418"))
                    .put(MANUAL_TOP, Sets.newHashSet("adaptive", "modernAdaptive", "adaptive0418"))
                    .put(STICKY, Sets.newHashSet("adaptive", "modernAdaptive", "adaptive0418"))
                    .put(MANUAL_STICKY, Sets.newHashSet("adaptive", "modernAdaptive", "adaptive0418"))
                    .put(TAPE, Sets.newHashSet("adaptive0418", "modernAdaptive", "posterHorizontal", "motion", "300x250", "300x300", "336x280"))
                    .put(MANUAL_TAPE, Sets.newHashSet("adaptive0418", "modernAdaptive", "posterHorizontal", "motion", "300x250", "300x300", "336x280"))
                    .build());

    Map<AdvertisingPlacement, Set<String>> POSSIBLE_MEDIA_SIZES_BY_PLACEMENT_MOBILE =
            new EnumMap<>(ImmutableMap.<AdvertisingPlacement, Set<String>>builder()
                    .put(TOP, Sets.newHashSet("320x50"))
                    .put(MANUAL_TOP, Sets.newHashSet("320x50"))
                    .put(STICKY, Sets.newHashSet("320x50"))
                    .put(MANUAL_STICKY, Sets.newHashSet("320x50"))
                    .put(TAPE, Sets.newHashSet("300x250", "300x300", "336x280", "100%x250"))
                    .put(MANUAL_TAPE, Sets.newHashSet("300x250", "300x300", "336x280", "100%x250"))
                    .build());

}
