package ru.yandex.webmaster3.storage.turbo.service.validation;

/**
 * Created by Oleg Bazdyrev on 18/09/2017.
 */
public class TurboParserException extends Exception {

    public enum ErrorCode {
        YANDEX_AD_NOT_EXISTS,
        YANDEX_AD_NON_TURBO,
        ADFOX_INVALID_CODE,
        YANDEX_INPAGE_INVALID_ID,
        YANDEX_INSTREAM_INVALID_ID,
        YANDEX_REC_WIDGET_INVALID_ID,
        ADFOX_INPAGE_INVALID_CODE,
        ADFOX_INSTREAM_INVALID_CODE,
        ADFOX_INTERSCROLLER_INVALID_CODE,
        CUSTOM_TRACKER_NOT_URL,
        MENU_EMPTY_LABEL,
        MENU_INVALID_URL,
        INVALID_CART_URL,
        INVALID_CHECKOUT_EMAIL,
        INVALID_TURBOCART_EMAIL,
        EMPTY_TURBOCART_EMAIL,
        DUPLICATE_COMMERCE_SECTION,
        INVALID_FEEDBACK_AGREEMENT,
        INVALID_FEEDBACK_AGREEMENT_URL,
        INVALID_FEEDBACK_URL,
        INVALID_FEEDBACK_EMAIL,
        INVALID_SEARCH_URL,
        PAYMENTS_TOKEN_NOT_FOUND,
        PAYMENTS_TOKEN_NOT_CONFIRMED,
        INVALID_METRIKA_ID,
        INVALID_BITRIX_URL,
        INVALID_MIN_ORDER_VALUE,
        INVALID_MENU_LABEL,
    }

    private final ErrorCode code;
    private final int index;

    public TurboParserException(String message, ErrorCode code) {
        super(message);
        this.code = code;
        this.index = -1;
    }

    public TurboParserException(String message, ErrorCode code, int index) {
        super(message);
        this.code = code;
        this.index = index;
    }

    public TurboParserException(String message, Throwable cause, ErrorCode code) {
        super(message, cause);
        this.code = code;
        this.index = -1;
    }

    public ErrorCode getCode() {
        return code;
    }

    public int getIndex() {
        return index;
    }
}
