package ru.yandex.webmaster3.storage.ugc;

import lombok.Builder;
import lombok.Data;

@Data
@Builder
public class SiteRating {
    Long positiveReviewsCount;
    Long negativeReviewsCount;
    Long totalCount;
    Long commentsCount;


    public static SiteRating build(Long positiveReviewsCount, Long negativeReviewsCount, Long commentsCount) {
        return SiteRating
                .builder()
                .positiveReviewsCount(positiveReviewsCount)
                .negativeReviewsCount(negativeReviewsCount)
                .totalCount(positiveReviewsCount + negativeReviewsCount)
                .commentsCount(commentsCount)
                .build();
    }
}
