package ru.yandex.webmaster3.storage.ugc;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.metrics.externals.AbstractExternalAPIService;

@Service
@Slf4j
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SiteRatingService extends AbstractExternalAPIService {

    private final SiteRatingCacheYDao siteRatingCacheYDao;
    private final UGCIntegrationService ugcIntegrationService;

    @Nullable
    public SiteRating getRating(String domain) {
        SiteRatingCacheYDao.CacheSiteRating cacheSiteRating = siteRatingCacheYDao.select(domain);

        if (cacheSiteRating == null) {
            SiteRating ratingFromApi = ugcIntegrationService.loadUGCThermometrInfo(domain);
            if (ratingFromApi == null) {
                siteRatingCacheYDao.insertEmpty(domain);
            } else {
                siteRatingCacheYDao.insert(
                        domain,
                        ratingFromApi.getPositiveReviewsCount(),
                        ratingFromApi.getNegativeReviewsCount(),
                        ratingFromApi.getCommentsCount()
                );
            }
            return ratingFromApi;
        } else {
            return cacheSiteRating.getSiteRating();
        }
    }
}
