package ru.yandex.webmaster3.storage.url.checker2.dao;

import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.url.common.dao.CommonUrlCheckRequestsYDao;

/**
 * @author leonidrom
 */
@Repository
public class UrlCheckRequestsYDao extends CommonUrlCheckRequestsYDao {
    private static final String TABLE_NAME = "url_check_requests";
    private static final String CREATED_TIME_INDEX = "created_time_index";

    public UrlCheckRequestsYDao() {
        super(PREFIX_URLCHECK, TABLE_NAME);
    }

    public long getHostRequestsCountAfter(WebmasterHostId hostId, DateTime fromDate) {
        return countAll()
                .secondaryIndex(CREATED_TIME_INDEX)
                .where(F.HOST_ID.eq(hostId))
                .and(F.CREATED_TIME.gte(fromDate))
                .queryOne();
    }
}
