package ru.yandex.webmaster3.storage.url.checker2.dao;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.url.common.dao.CommonUrlCheckRequestsYDao;
import ru.yandex.webmaster3.storage.url.common.data.UrlCheckRequestData;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

/**
 * @author leonidrom
 */
@Repository
public class UrlCheckYtRequestsYDao extends CommonUrlCheckRequestsYDao {
    private static final String TABLE_NAME = "url_check_yt_requests";

    public UrlCheckYtRequestsYDao() {
        super(PREFIX_URLCHECK, TABLE_NAME);
    }
    
    public void foreachRequest(Consumer<UrlCheckRequestData> consumer)  {
        streamReader(MAPPER, consumer);
    }

    public void deleteRequests(List<UrlCheckRequestData> batch) {
        var toDelete = batch.stream().map(req -> Pair.of(req.getHostId(), req.getRequestId())).collect(Collectors.toList());
        batchDelete(DELETE_VALUE_MAPPER, toDelete).execute();
    }

    private static final ValueDataMapper<Pair<WebmasterHostId, UUID>> DELETE_VALUE_MAPPER = ValueDataMapper.create(
            Pair.of(F.HOST_ID, r -> F.HOST_ID.get(r.getKey())),
            Pair.of(F.REQUEST_ID, r -> F.REQUEST_ID.get(r.getValue()))
    );
}
