package ru.yandex.webmaster3.storage.url.checker2.data;

/**
 * Created by leonidrom on 03/03/2017.
 */

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.storage.searchurl.samples.data.UrlStatusInfo;

/**
 * Вся интересная пользователю информация о проверенном URL.
 * Добывается из CH, если нужных нам данных там нет, то идем в Yt
 */
public class UrlCheckInfo {
    private final String title;
    private final IndexingInfo indexingInfo;
    private final SearchInfo searchInfo;

    @JsonCreator
    public UrlCheckInfo(String title,
                        IndexingInfo indexingInfo,
                        SearchInfo searchInfo) {
        this.title = title;
        this.indexingInfo = indexingInfo;
        this.searchInfo = searchInfo;
    }

    public static class IndexingInfo {
        private final int httpCode;
        private final DateTime lastAccess;

        public IndexingInfo(int httpCode, DateTime lastAccess) {
            this.httpCode = httpCode;
            this.lastAccess = lastAccess;
        }

        public int getHttpCode() {
            return httpCode;
        }

        public DateTime getLastAccess() {
            return lastAccess;
        }
    }

    public static class SearchInfo {
        private final int httpCode;
        private final DateTime lastAccess;
        private final UrlStatusInfo excludedStatus;
        private final boolean isFake;

        // для фейковых страниц никаких данных по httpCode и lastAccess в базе и Yt нет
        public static SearchInfo FAKE = new SearchInfo(0, null, null, true);

        public SearchInfo(int httpCode, DateTime lastAccess, UrlStatusInfo excludedStatus, boolean fake) {
            this.httpCode = httpCode;
            this.lastAccess = lastAccess;
            this.excludedStatus = excludedStatus;
            this.isFake = fake;
        }

        public int getHttpCode() {
            return httpCode;
        }

        public DateTime getLastAccess() {
            return lastAccess;
        }

        public UrlStatusInfo getExcludedStatus() {
            return excludedStatus;
        }

        public boolean isFake() {
            return isFake;
        }
    }

    public String getTitle() {
        return title;
    }

    public IndexingInfo getIndexingInfo() {
        return indexingInfo;
    }

    public SearchInfo getSearchInfo() {
        return searchInfo;
    }
}
