package ru.yandex.webmaster3.storage.url.checker2.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.UUID;

/**
 * Created by leonidrom on 02/03/2017.
 */
public class UrlCheckResultData {
    private final WebmasterHostId hostId;
    private final UUID requestId;
    private final DateTime completedTime;
    private final UrlCheckInfo info;

    public UrlCheckResultData(WebmasterHostId hostId, UUID requestId, DateTime completedTime, UrlCheckInfo info) {
        this.hostId = hostId;
        this.requestId = requestId;
        this.completedTime = completedTime;
        this.info = info;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public DateTime getCompletedTime() {
        return completedTime;
    }

    public UrlCheckInfo getInfo() {
        return info;
    }
}
