package ru.yandex.webmaster3.storage.url.checker3;

import com.datastax.driver.core.utils.UUIDs;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckDeviceType;
import ru.yandex.webmaster3.storage.crawl.RotorSettings;
import ru.yandex.webmaster3.storage.crawl.dao.RotorSettingsYDao;
import ru.yandex.webmaster3.storage.url.checker3.dao.UrlCheckDataBlocksYDao;
import ru.yandex.webmaster3.storage.url.checker3.dao.UrlCheckRequests2YDao;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockType;
import NUrlChecker.Request.EDataOrderItem;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * @author leonidrom
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Slf4j
public class UrlCheckRequestService2 {
    private static final int REQUESTS_FOR_HOST_PER_DAY_LIMIT = 100;

    private final UrlCheckRequests2YDao urlCheckRequests2YDao;
    private final UrlCheckDataBlocksYDao urlCheckDataBlocksYDao;
    private final RotorSettingsYDao rotorSettingsYDao;

    public int getRequestsLeftForHostToday(WebmasterHostId hostId) {
        int todayRequests = (int)urlCheckRequests2YDao.getHostRequestsCountAfter(hostId,
                DateTime.now().withTimeAtStartOfDay());
        return Math.max(0, REQUESTS_FOR_HOST_PER_DAY_LIMIT - todayRequests);
    }

    public void deleteResultAndRequest(WebmasterHostId hostId, UUID requestId) {
        urlCheckRequests2YDao.deleteRequest(hostId, requestId);
        urlCheckDataBlocksYDao.delete(requestId);
    }
}
