package ru.yandex.webmaster3.storage.url.checker3.data;

import lombok.Getter;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.url.checker3.UrlCheckRequestParams;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskPriority;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.url.checker3.data.UrlCheckDataBlockType;

import java.util.UUID;

/**
 * @author leonidrom
 */
@Getter
public class FetchUrlCheckDataBlockTaskData extends WorkerTaskData {
    private final UUID requestId;
    private final UrlCheckDataBlockType blockType;
    private final DateTime searchBaseDate;
    private final UrlCheckRequestParams params;

    public FetchUrlCheckDataBlockTaskData(WebmasterHostId hostId, UUID requestId, UrlCheckDataBlockType blockType,
                                          DateTime searchBaseDate, UrlCheckRequestParams params) {
        super(hostId, WorkerTaskPriority.HIGHEST);
        this.requestId = requestId;
        this.blockType = blockType;
        this.searchBaseDate = searchBaseDate;
        this.params = params;
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.FETCH_URLCHECK_DATA_BLOCK;
    }

    @Override
    public String getShortDescription() {
        return "Fetch url check data block";
    }
}

