package ru.yandex.webmaster3.storage.url.checker3.data;

import lombok.Data;
import lombok.With;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Seconds;

import java.util.Collection;
import java.util.UUID;

/**
 * @author leonidrom
 */
@Data
public class UrlCheckDataBlock {
    public static final Seconds FETCH_TIMEOUT = Seconds.seconds(180);
    public static final int MAX_TEXT_LENGTH = 50_000;

    private final UUID requestId;
    private final UrlCheckDataBlockType blockType;
    private final DateTime addDate;
    @With
    private final UrlCheckDataBlockState fetchState;
    @Nullable
    private final String data;

    public UrlCheckDataBlock withTimedOutCheck() {
        UrlCheckDataBlock b;
        if (!fetchState.isTerminal() && checkTimedOut()) {
            b = withFetchState(UrlCheckDataBlockState.TIMED_OUT);
        } else {
            b = this;
        }

        return b;
    }

    public boolean checkTimedOut() {
        return addDate.isBefore(DateTime.now().minus(FETCH_TIMEOUT));
    }

    public static boolean anyOfState(Collection<UrlCheckDataBlock> blocks, UrlCheckDataBlockState state) {
        return blocks.stream().anyMatch(b -> b.getFetchState() == state);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder("UrlCheckDataBlock{");
        sb.append("requestId=").append(requestId);
        sb.append(", blockType=").append(blockType);
        sb.append(", addDate=").append(addDate);
        sb.append(", fetchState=").append(fetchState);
        sb.append('}');
        return sb.toString();
    }
}
