package ru.yandex.webmaster3.storage.url.checker3.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author leonidrom
 */
public enum UrlCheckDataBlockState {
    IN_PROGRESS,
    DONE,
    TIMED_OUT,
    ROBOT_FETCH_ERROR,
    INTERNAL_ERROR,
    // don't forget to edit combineWith method below
    ;

    public boolean isTerminal() {
        return this != IN_PROGRESS;
    }

    public boolean isDone() {
        return this == DONE;
    }

    public UrlCheckDataBlockState combineWith(UrlCheckDataBlockState otherState) {
        if (this == DONE && otherState == DONE) {
            return DONE;
        }

        if (this == INTERNAL_ERROR || otherState == INTERNAL_ERROR) {
            return INTERNAL_ERROR;
        }

        if (this == ROBOT_FETCH_ERROR || otherState == ROBOT_FETCH_ERROR) {
            return ROBOT_FETCH_ERROR;
        }

        if (this == TIMED_OUT || otherState == TIMED_OUT) {
            return TIMED_OUT;
        }

        return IN_PROGRESS;
    }

    public static final EnumResolver<UrlCheckDataBlockState> R = EnumResolver.er(UrlCheckDataBlockState.class);
}
