package ru.yandex.webmaster3.storage.url.checker3.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;
import NUrlChecker.Request.EDataOrderItem;

import static NUrlChecker.Request.EDataOrderItem.*;


/**
 * @author leonidrom
 */
public enum UrlCheckDataBlockType {
    // добываем сами
    SEARCH_INFO(null),
    MOBILE_AUDIT(null),
    TEXT_CONTENT(null),
    SEARCH_BASE_DATE(null),
    ROTOR_RENDER_SETTINGS(null),
    URL_CHECK_REQUEST_PARAMS(null),

    // получаем от робота
    ROBOT_ROTOR_CHECK_RENDER_ON(EDOI_ROTORFULL_SCREENSHOT),
    ROBOT_SERVER_RESPONSE_RENDER_ON(EDOI_ROTORFULL_HTML),

    ROBOT_ROTOR_CHECK_RENDER_OFF(EDOI_ROTORLESS_SCREENSHOT),
    ROBOT_SERVER_RESPONSE_RENDER_OFF(EDOI_ROTORLESS_HTML),

    ROBOT_ARCHIVE_RENDER_ON(EDOI_ROTORFULL_ARCHIVE),
    ROBOT_ARCHIVE_RENDER_OFF(EDOI_ROTORLESS_ARCHIVE),

    ROBOT_INDEXING_INFO(EDOI_LAST_CRAWL_INFO)
    ;

    private final EDataOrderItem robotItem;


    public static final EnumResolver<UrlCheckDataBlockType> R = EnumResolver.er(UrlCheckDataBlockType.class);

    UrlCheckDataBlockType(EDataOrderItem robotItem) {
        this.robotItem = robotItem;
    }

    public EDataOrderItem getRobotItem() {
        return robotItem;
    }
}
