package ru.yandex.webmaster3.storage.url.checker3.data.blocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.Nullable;

/**
 * @author leonidrom
 *
 * Приходит от Роботного сервиса
 */
@Data
@RequiredArgsConstructor(onConstructor_ = @JsonCreator)
@NoArgsConstructor(force = true)
public class IndexingInfoData {
    @Nullable
    private final IndexingInfo indexingInfo;

    @Data
    @RequiredArgsConstructor(onConstructor_ = @JsonCreator)
    public static class IndexingInfo {
        private final int httpCode;
        private final int lastAccess;
        private final int mimeType;
        private final String redirectTarget;
        private final String relCanonicalTarget;
    }
}
