package ru.yandex.webmaster3.storage.url.checker3.data.blocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.ToString;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.storage.searchurl.samples.data.UrlStatusInfo;

/**
 * @author leonidrom
 *
 * Добывается из таблиц urls_for_webmaster_simple и content_attrs
 */
@NoArgsConstructor(force = true)
@RequiredArgsConstructor(onConstructor_ = @JsonCreator)
@Data
public class SearchInfoData {
    @Nullable
    private final String title;
    @Nullable
    private final String description;
    @Nullable
    private final SearchInfo searchInfo;

    @Data
    @RequiredArgsConstructor(onConstructor_ = @JsonCreator)
    public static class SearchInfo {
        private final int httpCode;
        private final DateTime lastAccess;
        private final UrlStatusInfo excludedStatus;
        private final boolean isFake;
        private final boolean isProcessedByRotor;
    }

    // для фейковых страниц никаких данных по httpCode и lastAccess в Yt нет
    public static SearchInfo FAKE = new SearchInfo(0, null, null, true, false);
}
