package ru.yandex.webmaster3.storage.url.checker3.data.blocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.ToString;
import ru.yandex.webmaster3.core.data.HttpResponsePart;
import ru.yandex.webmaster3.core.util.http.YandexMimeType;

import java.util.List;

/**
 * @author leonidrom
 */
@Data
@RequiredArgsConstructor(onConstructor_ = @JsonCreator)
@NoArgsConstructor(force = true)
public class ServerResponseData {
    private final HttpResponsePart httpResponsePart;

    // только ресурсы с плохими http кодами
    private final List<ResourceInfo> resourceInfos;

    @Data
    @RequiredArgsConstructor(onConstructor_ = @JsonCreator)
    @ToString
    public final static class ResourceInfo {
        private final String url;
        private final int httpCode;
        private final YandexMimeType mimeType;
    }
}
