package ru.yandex.webmaster3.storage.url.common.data;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.net.URL;
import java.util.UUID;

/**
 * Created by leonidrom on 02/03/2017.
 */
public class UrlCheckRequestData {
    private final WebmasterHostId hostId;
    private final UUID requestId;
    private final URL url;
    private final DateTime createdTime;
    private final UrlCheckRequestSource requestSource;

    public UrlCheckRequestData(WebmasterHostId hostId, UUID requestId, URL url, DateTime createdTime,
                               UrlCheckRequestSource requestSource) {
        this.hostId = hostId;
        this.requestId = requestId;
        this.url = url;
        this.createdTime = createdTime;
        this.requestSource = requestSource;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public URL getUrl() {
        return url;
    }

    public DateTime getCreatedTime() {
        return createdTime;
    }

    public UrlCheckRequestSource getRequestSource() {
        return requestSource;
    }
}
