package ru.yandex.webmaster3.storage.user;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

public enum CustomizableSurveyContentTypeEnum implements IntEnum {
    HEADER(0),
    TEXT(1),
    CHECKBOX(2),
    INPUT(3),
    ;

    private final int value;

    CustomizableSurveyContentTypeEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<CustomizableSurveyContentTypeEnum> R =
            IntEnumResolver.r(CustomizableSurveyContentTypeEnum.class);
}

