package ru.yandex.webmaster3.storage.user;

import java.util.List;

import lombok.Value;
import lombok.With;

@Value
@With
public class CustomizableSurveyData {
    String routeNameRegexp;
    List<CustomizableSurveyContent> texts;
    boolean enabled;
    String experiment;
    String surveyId;
    Integer daysBeforeShowAgain;
    Boolean isHidden;
    CustomizableSurveyTypeEnum surveyType;
    boolean isSurveyByHost;

    public static CustomizableSurveyData create(String routeNameRegexp, List<CustomizableSurveyContent> texts,
                                                boolean enabled,
                                                String experiment, String surveyId, Integer daysBeforeShowAgain,
                                                CustomizableSurveyTypeEnum surveyType, boolean isSurveyByHost) {
        return new CustomizableSurveyData(routeNameRegexp, texts, enabled, experiment, surveyId, daysBeforeShowAgain,
                null
                , surveyType, isSurveyByHost);
    }
}
