package ru.yandex.webmaster3.storage.user;

import java.util.Map;

import lombok.Value;
import lombok.With;

import ru.yandex.webmaster3.core.notification.LanguageEnum;

@Value
@With
public class ServiceAnnouncement {
    public static final ServiceAnnouncement EMPTY = new ServiceAnnouncement(null, null, false, null, Type.INFO);
    String routeNameRegexp;
    Map<LanguageEnum, String> texts;
    boolean enabled;
    String experiment;
    Type type;

    public String getType() {
        return type.name().toLowerCase();
    }

    public ServiceAnnouncement(String routeNameRegexp, Map<LanguageEnum, String> texts, boolean enabled,
                               String experiment, Type type) {
        this.routeNameRegexp = routeNameRegexp;
        this.texts = texts;
        this.enabled = enabled;
        this.experiment = experiment;
        this.type = type == null ? Type.INFO : type;
    }

    public enum Type {
        INFO,
        ERROR,
        ;
    }

}
