package ru.yandex.webmaster3.storage.user;

import java.util.Map;

import lombok.Value;
import lombok.With;

import ru.yandex.webmaster3.core.notification.LanguageEnum;

@Value
@With
public class ServiceSurvey {
    String routeNameRegexp;
    Map<String, Map<LanguageEnum, String>> texts;
    boolean enabled;
    String experiment;
    String type;
    Integer daysBeforeShowAgain;
    Boolean isHidden;

    public static ServiceSurvey create(String routeNameRegexp, Map<String, Map<LanguageEnum, String>> texts,
                                       boolean enabled,
                                       String experiment, String type, Integer daysBeforeShowAgain) {
        return new ServiceSurvey(routeNameRegexp, texts, enabled, experiment, type, daysBeforeShowAgain, null);
    }
}
