package ru.yandex.webmaster3.storage.user;

import org.joda.time.Instant;
import ru.yandex.wmtools.common.data.info.IPInfo;
import ru.yandex.wmtools.common.error.UserException;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SpamBanRule {
    private final UUID ruleId;
    private final String mask;
    private final int subnetLength;
    private final IPInfo ipInfo;
    private final long ownerId;
    private final boolean activeStatus;
    private final String cause;
    private final Instant updateDate;

    public SpamBanRule(UUID ruleId, String mask, int subnetLength, long adminUserId, boolean activeStatus, String cause, Instant updateDate) {
        this.ruleId = ruleId;
        this.mask = mask;
        this.subnetLength = subnetLength;
        try {
            this.ipInfo = IPInfo.createFromString(mask, subnetLength);
        } catch (UserException e) {
            throw new IllegalArgumentException(e);
        }
        ownerId = adminUserId;
        this.activeStatus = activeStatus;
        this.cause = cause;
        this.updateDate = updateDate;
    }

    public IPInfo getIpInfo() {
        return ipInfo;
    }

    public UUID getRuleId() {
        return ruleId;
    }

    public String getMask() {
        return mask;
    }

    public int getSubnetLength() {
        return subnetLength;
    }

    public long getOwnerId() {
        return ownerId;
    }

    public boolean getActiveStatus() {
        return activeStatus;
    }

    public String getCause() {
        return cause;
    }

    public Instant getUpdateDate() {
        return updateDate;
    }

}
