package ru.yandex.webmaster3.storage.user;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

public enum SurveyStateEnum implements IntEnum {
    SUBMIT(0),
    CLOSE(1),
    SHOW(2);

    private final int value;

    SurveyStateEnum(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<SurveyStateEnum> R = IntEnumResolver.r(SurveyStateEnum.class);
}
