package ru.yandex.webmaster3.storage.user;

import com.google.common.base.MoreObjects;
import ru.yandex.webmaster3.core.blackbox.BlackboxAttributeType;
import ru.yandex.webmaster3.core.blackbox.UserWithFields;
import ru.yandex.webmaster3.core.blackbox.UserWithLogin;
import ru.yandex.webmaster3.core.notification.LanguageEnum;

/**
 * @author avhaliullin
 */
public class UserPersonalInfo extends UserWithLogin {
    private final String fio;
    private final LanguageEnum language;

    public UserPersonalInfo(long userId, String login) {
        super(userId, login);
        this.fio = null;
        this.language = null;
    }


    public UserPersonalInfo(long userId, String login, String fio, LanguageEnum language) {
        super(userId, login);
        this.fio = fio;
        this.language = language;
    }

    public String getFio() {
        return fio;
    }

    public boolean isComplete() {
        return fio != null && language != null && getLogin() != null;
    }

    public LanguageEnum getLanguage() {
        return language;
    }

    public static UserPersonalInfo fromUserWithFields(UserWithFields userWithFields) {
        String login = userWithFields.getFields().get(BlackboxAttributeType.LOGIN);
        String displayName = userWithFields.getFields().get(BlackboxAttributeType.FIO);
        if (displayName == null) {
            displayName = login;
        }

        LanguageEnum language;
        String langTag = userWithFields.getFields().get(BlackboxAttributeType.LANG);
        switch (langTag) {
            case "en":
            case "tr":
                language = LanguageEnum.EN;
                break;
            case "ru":
            case "kk":
            case "uk":
            case "be":
            default:
                language = LanguageEnum.RU;
                break;
        }

        return new UserPersonalInfo(userWithFields.getUid(), login, displayName, language);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("fio", fio)
                .add("language", language)
                .toString();
    }
}
