package ru.yandex.webmaster3.storage.user;

import com.datastax.driver.core.utils.UUIDs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.user.takeout.UserTakeoutRequestType;

import java.util.UUID;

/**
 * @author leonidrom
 */
public class UserTakeoutRequest {
    private final UUID requestId;
    private final long userId;
    private final UserTakeoutRequestType type;
    private final UserTakeoutRequestStatus status;
    private final String data;
    private final DateTime lastUpdate;

    public UserTakeoutRequest(UUID requestId, long userId, UserTakeoutRequestType type, UserTakeoutRequestStatus status) {
        this(requestId, userId, type, status, null, new DateTime(UUIDs.unixTimestamp(requestId)));
    }

    public UserTakeoutRequest(UUID requestId, long userId, UserTakeoutRequestType type,
                              UserTakeoutRequestStatus status, String data, DateTime lastUpdate) {
        this.requestId = requestId;
        this.userId = userId;
        this.type = type;
        this.status = status;
        this.data = data;
        this.lastUpdate = lastUpdate;
    }

    @NotNull
    public UUID getRequestId() {
        return requestId;
    }

    public long getUserId() {
        return userId;
    }

    @NotNull
    public UserTakeoutRequestType getType() {
        return type;
    }

    @NotNull
    public UserTakeoutRequestStatus getStatus() {
        return status;
    }

    @Nullable
    public String getData() {
        return data;
    }

    @NotNull
    public DateTime getLastUpdate() {
        return lastUpdate;
    }
}
