package ru.yandex.webmaster3.storage.user;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author leonidrom
 */
public enum UserTakeoutRequestStatus implements IntEnum {
    IN_PROGRESS(0, false),
    DONE(1, true),
    FAILED(2, true),
    ;

    private final int value;
    private final boolean isTerminal;

    UserTakeoutRequestStatus(int value, boolean isTerminal) {
        this.value = value;
        this.isTerminal = isTerminal;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isTerminal() {
        return isTerminal;
    }

    public static final IntEnumResolver<UserTakeoutRequestStatus> R = IntEnumResolver.r(UserTakeoutRequestStatus.class);
}
