package ru.yandex.webmaster3.storage.user;

import com.fasterxml.jackson.core.type.TypeReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.yandex.webmaster3.storage.util.JsonDBMapping;

import java.util.*;

/**
 * @author leonidrom
 *
 * Результат выгрузки пользовательских данных из одной таблицы.
 * Для пользователя будет выглядеть как кусок JSON'а в виде:
 *     "label": "data as JSON"
 */
public class UserTakeoutTableData {
    @NotNull
    private final String label;

    @Nullable
    private final Object data;

    /**
     * @param label имя поля в итоговом json'е для этих данных
     * @param data сами данные в виде некоего объекта, который Jackson сможет сериализовать в строку
     */
    public UserTakeoutTableData(@NotNull String label, @Nullable Object data) {
        this.label = label;
        this.data = data;
    }

    public Map<String, Object> getAsMap() {
        Map<String, Object> m = new HashMap<>();
        if (data != null) {
            m.put(label, data);
        } else {
            m.put(label, Collections.emptySet());
        }

        return m;
    }
}
