package ru.yandex.webmaster3.storage.user.dao;

import java.util.List;

import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.user.CustomizableSurveyContent;
import ru.yandex.webmaster3.storage.user.CustomizableSurveyData;
import ru.yandex.webmaster3.storage.user.CustomizableSurveyTypeEnum;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

@Repository("PopupSurveyYDao")

public class CustomizableSurveyYDao extends AbstractYDao {
    private static final DataMapper<CustomizableSurveyData> MAPPER = DataMapper.create(
            F.ROUTE_NAME_REGEXP, F.TEXTS, F.ENABLED, F.EXPERIMENT, F.SURVEY_ID, F.DAYS_BEFORE_SHOW_AGAIN,
            F.SURVEY_TYPE, F.IS_SURVEY_BY_HOST,
            CustomizableSurveyData::create
    );

    public CustomizableSurveyYDao() {
        super(PREFIX_INTERNAL, "service_customizable_survey");
    }

    public List<CustomizableSurveyData> getServiceSurveys() {
        return select(MAPPER)
                .queryForList();
    }

    private static class F {
        static final Field<String> ROUTE_NAME_REGEXP = Fields.stringField("route_name_regexp");
        static final Field<List<CustomizableSurveyContent>> TEXTS = Fields.jsonField2("texts",
                new TypeReference<>() {
                });
        static final Field<Boolean> ENABLED = Fields.boolField("enabled");
        static final Field<String> EXPERIMENT = Fields.stringField("experiment");
        static final Field<String> SURVEY_ID = Fields.stringField("survey_id");
        static final Field<CustomizableSurveyTypeEnum> SURVEY_TYPE = Fields.stringEnumField("survey_type",
                CustomizableSurveyTypeEnum.R);
        static final Field<Integer> DAYS_BEFORE_SHOW_AGAIN = Fields.intField("days_before_show_again");
        static final Field<Boolean> IS_SURVEY_BY_HOST = Fields.boolField("is_survey_by_host");

    }
}
