package ru.yandex.webmaster3.storage.user.dao;

import org.springframework.jdbc.core.RowMapper;
import ru.yandex.webmaster3.storage.user.message.MessageId;
import ru.yandex.webmaster3.storage.util.sql.mapper.SQLDataUtils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public class MessageIdSQLMapper implements RowMapper<MessageId> {
    public static final String FIELD_EVENT_UUID = "event_uuid";
    public static final String FIELD_MESSAGE_HASH = "hash";

    @Override
    public MessageId mapRow(ResultSet rs, int rowNum) throws SQLException {
        UUID eventUuid = SQLDataUtils.getUUID(rs, FIELD_EVENT_UUID);
        long messageHash = rs.getLong(FIELD_MESSAGE_HASH);
        return new MessageId(eventUuid, messageHash);
    }

    public static String declareFields() {
        return FIELD_EVENT_UUID + ", " +
                FIELD_MESSAGE_HASH + " ";

    }

    public static final MessageIdSQLMapper INSTANCE = new MessageIdSQLMapper();
}
