package ru.yandex.webmaster3.storage.user.dao;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.storage.user.ServiceSurvey;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

@Repository("serviceSurveyYDao")
public class ServiceSurveyYDao extends AbstractYDao {
    private static final DataMapper<ServiceSurvey> MAPPER = DataMapper.create(
            F.ROUTE_NAME_REGEXP, F.TEXTS, F.ENABLED, F.EXPERIMENT, F.TYPE, F.DAYS_BEFORE_SHOW_AGAIN,
            ServiceSurvey::create
    );

    public ServiceSurveyYDao() {
        super(PREFIX_INTERNAL, "service_survey");
    }

    public List<ServiceSurvey> getServiceSurveys() {
        return select(MAPPER)
                .queryForList();
    }

    private static class F {
        static final Field<String> ROUTE_NAME_REGEXP = Fields.stringField("route_name_regexp");
        static final Field<Map<String, Map<LanguageEnum, String>>> TEXTS = Fields.jsonField2("texts",
                new TypeReference<>() {
                });
        static final Field<Boolean> ENABLED = Fields.boolField("enabled");
        static final Field<String> EXPERIMENT = Fields.stringField("experiment").makeOptional();
        static final Field<String> TYPE = Fields.stringField("type").makeOptional();
        static final Field<Integer> DAYS_BEFORE_SHOW_AGAIN = Fields.intField("days_before_show_again").makeOptional();
    }
}
