package ru.yandex.webmaster3.storage.user.dao;

import org.springframework.jdbc.core.RowMapper;
import ru.yandex.webmaster3.storage.util.sql.mapper.SQLDataUtils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

/**
 * @author avhaliullin
 */
public class UserMessagePreMapper implements RowMapper<UserMessagePreMapper.UnParsedMessage> {
    public static final String FIELD_USER_ID = "user_id";
    public static final String FIELD_DATETIME = "date_time";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_HOST_ID = "host_id";
    public static final String FIELD_IS_READ = "is_read";
    public static final String FIELD_IS_CRITICAL = "is_critical";
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_EVENT_UUID = "event_uuid";
    public static final String FIELD_MESSAGE_HASH = "hash";

    @Override
    public UnParsedMessage mapRow(ResultSet rs, int rowNum) throws SQLException {
        long userId = rs.getLong(FIELD_USER_ID);
        int type = rs.getInt(FIELD_TYPE);
        String hostId = SQLDataUtils.getStringNullable(rs, FIELD_HOST_ID);
        boolean read = rs.getBoolean(FIELD_IS_READ);
        boolean critical = rs.getBoolean(FIELD_IS_CRITICAL);
        Timestamp time = rs.getTimestamp(FIELD_DATETIME);
        String message = rs.getString(FIELD_MESSAGE);
        byte[] uuid = rs.getBytes(FIELD_EVENT_UUID);
        long hash = rs.getLong(FIELD_MESSAGE_HASH);

        return new UnParsedMessage(userId, type, hostId, read, critical, time, message, uuid, hash);
    }

    public static class UnParsedMessage {

        public final long userId;
        public final int type;
        public final String hostId;
        public final boolean read;
        public final boolean critical;
        public final Timestamp date;
        public final String message;
        public final byte[] uuid;
        public final long hash;

        public UnParsedMessage(long userId, int type, String hostId, boolean read, boolean critical, Timestamp date, String message, byte[] uuid, long hash) {
            this.userId = userId;
            this.type = type;
            this.hostId = hostId;
            this.read = read;
            this.critical = critical;
            this.date = date;
            this.message = message;
            this.uuid = uuid;
            this.hash = hash;
        }

    }

    public static final UserMessagePreMapper INSTANCE = new UserMessagePreMapper();

}
