package ru.yandex.webmaster3.storage.user.message;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlChange;
import ru.yandex.webmaster3.storage.importanturls.data.ImportantUrlsChange;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;

/**
 * @author avhaliullin
 */
public enum MessageTypeEnum implements IntEnum, Discriminator<MessageContent> {
    PLAIN(0, MessageContent.PlainMessage.class, false),
    TREND(1, MessageContent.TrendMessage.class, true),
    VIRUS(2, MessageContent.VirusMessage.class, true),
    SERPLINKS_UPDATE(3, MessageContent.SerpLinksUpdate.class, true),
    CLEAR_VIRUS(4, MessageContent.VirusMessage.class, true),
    DISTRIBUTION(5, MessageContent.Distribution.class, false),
    CHECKLIST_CHANGES(6, MessageContent.ChecklistChanges.class, true),
    MAIN_MIRROR_CHANGED(7, MessageContent.MainMirrorChanged.class, true),
    SEARCH_BASE_UPDATE(8, MessageContent.SearchBaseUpdate.class, false),
    SEARCH_BASE_UPDATE_NEW(9, MessageContent.SearchBaseUpdateNew.class, false),
    URL_TITLE_CHANGE(10, ImportantUrlChange.TitleChange.class, true),
    URL_INDEXING_LAST_ACCESS_CHANGE(11, ImportantUrlChange.IndexingLastAccessChange.class, true),
    URL_INDEXING_STATUS_CHANGE(12, ImportantUrlChange.HttpCodeChange.class, true),
    URL_SEARCH_LAST_ACCESS_CHANGE(13, ImportantUrlChange.SearchLastAccessChange.class, true),
    URL_SEARCH_STATUS_CHANGE(14, ImportantUrlChange.SearchUrlStatusChange.class, true),
    HOST_ACCESS_DELEGATED_SOMEONE_ELSE(16, MessageContent.HostAccessDelegatedSomeoneElse.class, true),
    HOST_ACCESS_DELEGATED_TO_USER(17, MessageContent.HostAccessDelegatedToUser.class, false),
    HOST_REGION_CHANGED(18, MessageContent.HostRegionChanged.class, true),
    HOST_REGION_CHANGE_CANCELLED(19, MessageContent.HostRegionChangeCancelled.class, true),
    HOST_TREND_OPENED(20, MessageContent.HostTrendOpened.class, true),
    HOST_RECOMMENDED_OPENED(21, MessageContent.HostRecommendedOpened.class, true),
    HOST_ACCESS_LOST(22, MessageContent.HostAccessLost.class, true),
    HOST_RECOMMENDED_CLOSED(23, MessageContent.HostRecommendedClosed.class, true),
    HOST_DISPLAY_NAME_CHANGED(24, MessageContent.HostDisplayNameChanged.class, true),
    HOST_DISPLAY_NAME_CHANGE_CANCELLED(25, MessageContent.HostDisplayNameChangeCancelled.class, true),
    HOST_METRIKA_COUNTER_BINDING_REQUEST(26, MessageContent.HostMetrikaCounterBindingRequest.class, true),
    HOST_METRIKA_COUNTER_BINDING_REQUEST_CANCELLED(27, MessageContent.HostMetrikaCounterBindingRequestCancelled.class, true),
    HOST_METRIKA_COUNTER_BINDING_DELETED(28, MessageContent.HostMetrikaCounterBindingDeleted.class, true),
    HOST_ACCESS_DELEGATED_TO_NOT_USER(29, MessageContent.HostAccessDelegatedToNotUser.class, false),
    HOST_COMPANY_PROFILE_NOT_FILLED(30, MessageContent.HostCompanyProfileNotFilled.class, true),
    URL_DESCRIPTION_CHANGE(31, ImportantUrlChange.DescriptionChange.class, true),
    URL_REL_CANONICAL_TARGET_CHANGE(32, ImportantUrlChange.RelCanonicalTargetChange.class, true),
    TURBO_AUTOPARSED_PAGES_APPEARED(33, MessageContent.TurboAutoparsedPagesAppeared.class, true),
    SEARCH_BASE_UPDATE_ALL_USER_HOSTS(34, MessageContent.SearchBaseUpdateNewAllUserHosts.class, false),
    URL_TITLE_CHANGE_ALL_HOST_PAGES(35, ImportantUrlsChange.TitleChangeAllHostPages.class, true),
    URL_INDEXING_LAST_ACCESS_CHANGE_ALL_HOST_PAGES(36, ImportantUrlsChange.IndexingLastAccessChangeAllHostPages.class, true),
    URL_SEARCH_LAST_ACCESS_CHANGE_ALL_HOST_PAGES(37, ImportantUrlsChange.SearchLastAccessChangeAllHostPages.class, true),
    URL_INDEXING_STATUS_CHANGE_ALL_HOST_PAGES(38, ImportantUrlsChange.HttpCodeChangeAllHostPages.class, true),
    URL_SEARCH_STATUS_CHANGE_ALL_HOST_PAGES(39, ImportantUrlsChange.SearchUrlStatusChangeAllHostPages.class, true),
    URL_DESCRIPTION_CHANGE_ALL_HOST_PAGES(40, ImportantUrlsChange.DescriptionChangeAllHostPages.class, true),
    URL_REL_CANONICAL_TARGET_CHANGE_ALL_HOST_PAGES(41, ImportantUrlsChange.RelCanonicalTargetChangeAllHostPages.class, true),
    ROBOTS_TXT_CHANGE(42, MessageContent.RobotsTxtChange.class, true),
    NEW_DOMAINS_NOTIFICATION(43, MessageContent.NewDomainsNotification.class, true),
    HOST_METRIKA_COUNTER_CRAWL_SUSPENDED(44, MessageContent.HostMetrikaCounterCrawlSuspended.class, true),
    HOST_METRIKA_COUNTER_CRAWL_SAMPLES_UPDATED(45, MessageContent.HostMetrikaCounterCrawlSamplesUpdated.class, true),
    TURBO_LISTINGS_AVAILABLE(46, MessageContent.TurboListingsAvailable.class, true),
    TURBO_ADV_SETTINGS_CHANGE(47, MessageContent.TurboAdvSettingsChanged.class, true),
    IMPORTANT_URLS_AUTO_ADD(48, MessageContent.AutoAddedImportantUrls.class, true),
    NEW_REVIEW(49, MessageContent.NewReviewAvailable.class, true),
    UNVERIFIED_HOST_REMOVAL_AFTER_WEEK(50, MessageContent.UnverifiedHostRemovalAfterWeek.class, true),
    UNVERIFIED_HOST_REMOVAL_AFTER_THREE_WEEK(51, MessageContent.UnverifiedHostRemovalAfterThreeWeek.class, true),
    TURBO_COMMERCE_SETTINGS_CHANGE(52, MessageContent.TurboCommerceSettingsChanged.class, true),
    IKS_UPDATE(53, MessageContent.IksNewInfo.class, true),
    TURBO_SCC_PASS(54, MessageContent.TurboSccPass.class, true),
    TURBO_SCC_FAILED(55, MessageContent.TurboSccFailed.class, true),
    TURBO_SCC_BANNED(56, MessageContent.TurboSccBanned.class, true),
    TURBO_SCC_UNBANNED(57, MessageContent.TurboSccUnbanned.class, true),
    AUTO_ADD_MAIN_MIRROR(58, MessageContent.AutoAddMainMirror.class, true),
    NO_MAIN_MIRRORS(59, MessageContent.NoMainMirrors.class, true),
    VIDEOHOST_OFFER_CONFIRMED(60, MessageContent.VideohostOfferConfirmed.class, true),
    VIDEOHOST_OFFER_HAS_PAPER(61, MessageContent.VideohostOfferHasPaper.class, true),
    VIDEOHOST_OFFER_REDUNDANT(62, MessageContent.VideohostOfferRedundant.class, true),
    FEEDS_SCC_FAILED(63, MessageContent.FeedsSccFailed.class, true),
    FEEDS_SCC_BANNED(64, MessageContent.FeedsSccBanned.class, true),
    NCA_CERTIFICATE(65, MessageContent.NcaCertificate.class, true),
    FEEDS_PINGER_DISABLE(66, MessageContent.FeedsPingerDisable.class, true),
    FEEDS_PINGER_ENABLE(67, MessageContent.FeedsPingerEnable.class, true),
    NCA_CTLOG_CERTIFICATE(68, MessageContent.NcaCtlogCertificate.class, true),
    FEEDS_SCC_PASSED(69, MessageContent.FeedsSccPassed.class, true),
    FEEDS_DEFECT_RATE_FAILED(70, MessageContent.FeedsDefectRateFailed.class, true),
    FEEDS_VALIDATION_FAILED(71, MessageContent.FeedsValidationFailed.class, true),
    ;

    private final int value;
    private final Class<? extends MessageContent> messageClass;
    private final boolean requiresHost;

    MessageTypeEnum(int value, Class<? extends MessageContent> messageClass, boolean requiresHost) {
        this.value = value;
        this.messageClass = messageClass;
        this.requiresHost = requiresHost;
    }

    @Override
    public int value() {
        return value;
    }

    public boolean isRequiresHost() {
        return requiresHost;
    }

    public Class<? extends MessageContent> getMessageClass() {
        return messageClass;
    }

    @Override
    public Class<? extends MessageContent> getDataClass() {
        return getMessageClass();
    }

    public boolean isLegacy() {
        return LEGACY_TYPES.contains(this);
    }

    public static final IntEnumResolver<MessageTypeEnum> R = IntEnumResolver.r(MessageTypeEnum.class);

    // Влияет только на мониторинг, поэтому пока этот список может быть неполным
    public static final Set<MessageTypeEnum> LEGACY_TYPES = Collections.unmodifiableSet(EnumSet.of(
            VIRUS, SERPLINKS_UPDATE, CLEAR_VIRUS, SEARCH_BASE_UPDATE, TREND));
}
