package ru.yandex.webmaster3.storage.user.message;

import org.joda.time.base.AbstractInstant;

import ru.yandex.webmaster3.core.notification.UTMLabels;
import ru.yandex.webmaster3.core.util.TimeUtils;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;

/**
 * @author avhaliullin
 */
public class MessageUTMUtils {
    public static String getMessageUTMCampaign(MessageContent message) {
        if (message instanceof MessageContent.ChecklistChanges) {
            MessageContent.ChecklistChanges checklistChanges = (MessageContent.ChecklistChanges) message;
            return "checklist_" + checklistChanges.getProblemType().name().toLowerCase();
        } else {
            return message.getType().name().toLowerCase();
        }
    }

    public static UTMLabels getLabelsForMessage(MessageContent messageContent, AbstractInstant time) {
        return UTMLabels.createService(getMessageUTMCampaign(messageContent), time.toDateTime(TimeUtils.EUROPE_MOSCOW_ZONE).toLocalDate(),null);
    }
}
