package ru.yandex.webmaster3.storage.user.message;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author avhaliullin
 */
public class MessagesFilter {
    private final boolean onlyCritical;
    private final boolean onlyUnread;
    private final WebmasterHostId hostName;

    public MessagesFilter(boolean onlyCritical, boolean onlyUnread, WebmasterHostId hostName) {
        this.onlyCritical = onlyCritical;
        this.onlyUnread = onlyUnread;
        this.hostName = hostName;
    }

    public boolean isOnlyCritical() {
        return onlyCritical;
    }

    public boolean isOnlyUnread() {
        return onlyUnread;
    }

    public WebmasterHostId getHostId() {
        return hostName;
    }
}
