package ru.yandex.webmaster3.storage.user.message;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class MessagesPager {
    private final UUID fromId;
    private final int pageSize;

    public MessagesPager(UUID fromId, int pageSize) {
        this.fromId = fromId;
        this.pageSize = pageSize;
    }

    public UUID getFromId() {
        return fromId;
    }

    public int getPageSize() {
        return pageSize;
    }

    public static MessagesPager create(String fromId, int pageSize) {
        UUID id = fromId == null ? null : UUID.fromString(fromId);
        return new MessagesPager(id, pageSize);
    }
}
