package ru.yandex.webmaster3.storage.user.message.iks;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.HierarchyTypeField;
import ru.yandex.webmaster3.core.util.json.polymorphic.Polymorphic;

/**
 * ishalaru
 * 05.11.2020
 **/
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "messageType")
public abstract class IksMessageContent implements Polymorphic<IksMessageType> {
    private IksMessageType messageType;

    protected IksMessageContent(IksMessageType messageType) {
        this.messageType = messageType;
    }

    @HierarchyTypeField
    public IksMessageType getMessageType() {
        return messageType;
    }

    @Override
    @JsonProperty(value = "messageType")
    public IksMessageType getType() {
        return messageType;
    }

    public static class IksUpdate extends IksMessageContent {
        private List<WebmasterHostId> hostIds;
        private List<Long> iksValues;

        public IksUpdate(@JsonProperty("hostIds") List<WebmasterHostId> hostIds, @JsonProperty("iksValues") List<Long> iksValues) {
            super(IksMessageType.UPDATE);
            this.hostIds = hostIds;
            this.iksValues = iksValues;
        }

        public List<WebmasterHostId> getHostIds() {
            return hostIds;
        }

        public List<Long> getIksValues() {
            return iksValues;
        }
    }

    public static class IksRival extends IksMessageContent {
        private Long uuid;
        private List<String> hosts;

        public IksRival(@JsonProperty("uuid") Long uuid,
                        @JsonProperty("hosts") List<String> hosts) {
            super(IksMessageType.RIVAL_UPDATE);
            this.uuid = uuid;
            this.hosts = hosts;
        }

        public Long getUuid() {
            return uuid;
        }

        public List<String> getHosts() {
            return hosts;
        }


    }

}
