package ru.yandex.webmaster3.storage.user.message.iks;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * ishalaru
 * 05.11.2020
 **/
public enum IksMessageType implements IntEnum, Discriminator<IksMessageContent> {
    UPDATE(1, IksMessageContent.IksUpdate.class),
    RIVAL_UPDATE(2, IksMessageContent.IksRival.class);

    private int value;
    private Class<? extends IksMessageContent> clazz;

    IksMessageType(int value, Class<? extends IksMessageContent> clazz) {
        this.value = value;
        this.clazz = clazz;
    }


    @Override
    public int value() {
        return value;
    }

    @Override
    public Class<? extends IksMessageContent> getDataClass() {
        return clazz;
    }
}
