package ru.yandex.webmaster3.storage.user.notification;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum HostNotificationMode implements IntEnum {
    DEFAULT(0),
    ENABLED(1),
    DISABLED(2),;

    private final int value;

    HostNotificationMode(int value) {
        this.value = value;
    }

    public boolean isEnabled(boolean defaultValue) {
        switch (this) {
            case DEFAULT:
                return defaultValue;
            case ENABLED:
                return true;
            case DISABLED:
                return false;
            default:
                throw new RuntimeException("Unknown mode " + this);
        }
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<HostNotificationMode> R = IntEnumResolver.r(HostNotificationMode.class);
}
