package ru.yandex.webmaster3.storage.user.notification;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.storage.notifications.NotificationChannel;

/**
 * @author avhaliullin
 */
public enum NotificationType implements IntEnum {
    SERP_LINKS_UPDATE(0, NotificationChannel.SERVICE),
    PERSONAL_SUPPORT(1, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    // in-service not supported:
    GLOBAL_NOTIFICATION(2, EnumSet.of(NotificationChannel.EMAIL), EnumSet.noneOf(NotificationChannel.class)),
    MAIN_MIRROR_UPDATE(3, NotificationChannel.ALL_NOTIFICATION_CHANNEL, NotificationChannel.ALL_NOTIFICATION_CHANNEL),
    SEARCH_BASE_UPDATE(4, NotificationChannel.SERVICE),
    SITE_PROBLEM_FATAL(5, NotificationChannel.ALL_NOTIFICATION_CHANNEL, NotificationChannel.ALL_NOTIFICATION_CHANNEL),
    SITE_PROBLEM_CRITICAL(6, NotificationChannel.ALL_NOTIFICATION_CHANNEL, NotificationChannel.ALL_NOTIFICATION_CHANNEL),
    SITE_PROBLEM_POSSIBLE(7, NotificationChannel.SERVICE),
    SITE_PROBLEM_RECOMMENDATION(8, NotificationChannel.SERVICE),
    URL_TITLE_CHANGE(9, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    URL_INDEXING_LAST_ACCESS_CHANGE(10),
    URL_INDEXING_STATUS_CHANGE(11, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    URL_SEARCH_LAST_ACCESS_CHANGE(12),
    URL_SEARCH_STATUS_CHANGE(13, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    DIGEST(14, EnumSet.of(NotificationChannel.EMAIL), EnumSet.noneOf(NotificationChannel.class)), // in-service not supported
    SITE_ACCESS(15, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    METRIKA_COUNTERS(16, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    SITE_REGIONS(17, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    RECOMMENDED_QUERIES(19, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    TRENDS(20, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    SITE_DISPLAY_NAME(21, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    URL_DESCRIPTION_CHANGE(23, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    URL_REL_CANONICAL_TARGET_CHANGE(24, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    TURBO_ERROR(25, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    TURBO_WARNING(26, NotificationChannel.SERVICE),
    TURBO_BAN(27, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    TURBO_NEW(28, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    NEW_DOMAINS_NOTIFICATION(29),
    ROBOTS_TXT_CHANGE(30),
    METRIKA_COUNTER_CRAWL(31),
    TURBO_LISTINGS_NEW(32),
    TURBO_ADV_SETTINGS_CHANGE(33, NotificationChannel.ALL_NOTIFICATION_CHANNEL, NotificationChannel.ALL_NOTIFICATION_CHANNEL),
    IMPORTANT_URLS_AUTO_ADD(34, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    NEW_REVIEW_AVAILABLE(35, NotificationChannel.ALL_NOTIFICATION_CHANNEL, NotificationChannel.ALL_NOTIFICATION_CHANNEL),
    POST_WELCOME_NOTIFICATION(36, NotificationChannel.EMAIL),
    UNVERIFIED_HOST_REMOVAL_AFTER_WEEK(37, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    UNVERIFIED_HOST_REMOVAL_AFTER_THREE_WEEK(38, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    TURBO_COMMERCE_SETTINGS_CHANGE(39, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    DIGEST_LITE(40, EnumSet.of(NotificationChannel.EMAIL), EnumSet.of(NotificationChannel.EMAIL)), // in-service not supported
    IKS_UPDATE(41, NotificationChannel.ALL_NOTIFICATION_CHANNEL, NotificationChannel.ALL_NOTIFICATION_CHANNEL),
    TURBO_SCC_PASS(42, NotificationChannel.SERVICE, NotificationChannel.EMAIL),
    TURBO_SCC_FAILED(43, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    TURBO_SCC_BANNED(44, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    TURBO_SCC_UNBANNED(45, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    MAIN_MIRROR_AUTO_ADD(46, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    ACCESS_LOST(47, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    NO_MAIN_MIRROR(48, NotificationChannel.EMAIL),
    VIDEOHOST_OFFER(49, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    FEEDS_INFO(50, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    NCA_CERTIFICATE(51, NotificationChannel.EMAIL, NotificationChannel.SERVICE),
    ;
    private final int value;
    private final Set<NotificationChannel> defaultChannels;
    private final Set<NotificationChannel> supportedChannels;

    NotificationType(int value, Set<NotificationChannel> supportedChannels, Set<NotificationChannel> defaultChannels) {
        this.value = value;
        this.defaultChannels = Collections.unmodifiableSet(defaultChannels);
        this.supportedChannels = Collections.unmodifiableSet(supportedChannels);
    }

    NotificationType(int value, NotificationChannel... defaultChannels) {
        this.value = value;
        EnumSet<NotificationChannel> channels = EnumSet.noneOf(NotificationChannel.class);
        channels.addAll(Arrays.asList(defaultChannels));
        this.defaultChannels = Collections.unmodifiableSet(channels);
        this.supportedChannels = Collections.unmodifiableSet(EnumSet.of(NotificationChannel.SERVICE, NotificationChannel.EMAIL));
    }

    public Set<NotificationChannel> getSupportedChannels() {
        return supportedChannels;
    }

    public Set<NotificationChannel> getDefaultChannels() {
        return defaultChannels;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<NotificationType> R = IntEnumResolver.r(NotificationType.class);
}
